; Custom Replay Routine - DeliPlayer
;
	incdir	"Include:"
	include	"misc/DevpacMacros.i"
	include	"misc/deliplayer.i"

;
;
	SECTION Player,Code
;
;

	PLAYERHEADER PlayerTagArray

	dc.b '$VER: Reality Project Megaran Demo Custom Player V1.0 (06 Jun 2004)',0
	even

PlayerTagArray
	dc.l	DTP_CustomPlayer,1		; CustomPlayer - Tag (important !!!)
	dc.l	DTP_Creator,playercreator
	dc.l	DTP_Interrupt,mt_music
	dc.l	DTP_InitPlayer,InitPly
	dc.l	DTP_EndPlayer,EndPly
	dc.l	DTP_InitSound,mt_init
	dc.l	DTP_EndSound,mt_end
	dc.l	DTP_DeliBase,delibase
	dc.l	DTP_Flags,PLYF_SONGEND
	dc.l	TAG_DONE

delibase	
	dc.l	0

playercreator	
	dc.b	'Reality 1991 from demo called Project Megaran',10
	dc.b	'Music by Pete/Enigma',10
	dc.b	'Adapted for Deliplayer by VrS!/Apocalypse Bay',0
	even

*-----------------------------------------------------------------------*
;
; Init Player

InitPly
	move.l	dtg_AudioAlloc(a5),a0		; Function
	jsr	(a0)
	rts

*-----------------------------------------------------------------------*
;
; End Player

EndPly
	move.l	dtg_AudioFree(a5),a0		; Function
	jsr	(a0)
	rts

SongEnd
	movem.l	d0-d7/a0-a6,-(a7)
	move.l	delibase(pc),a5
	move.l	dtg_SongEnd(a5),a0
	jsr	(a0)
	movem.l	(a7)+,d0-d7/a0-a6
	rts
	
*-----------------------------------------------------------------------*
; custom player module "WindSurf" / Project Megaran - Reality
; based on NoiseTracker 1.0 replay routine 
; 3b6 (950) = songlen (31 instr.)
; 400 / 3b8 = pattern sequence table (31 instr)
; 43c = pattern start
*----------------------------*
; structure: offset / byte
*----------------------------*
; 00 - 20 : songname : WINDSURF IN C-MINOR,0
; 20 - 22 ($14) : sample1 name : (/) by Pete of Enigma,0 
; 42 - 2 ($2a) : sample1 len : $4000
; 
; modification : Songlen = $3FE
; modification : Pattern Position = $400
; modification : constante = $37

mt_init:
	lea     mt_data,A0
	movea.l A0,A1
	adda.l  #$400,A1	; NT/ST: $3B8 - Pattern Position
	moveq.l #$37,D0		; NT/ST: $7F : constante Protrack
	moveq.l #0,D1
mt_loop1: 
	move.l  D1,D2
	subq.w  #1,D0
mt_loop2: 
	move.b  (A1)+,D1
	cmp.b   D2,D1
	bgt.s   mt_loop1
	dbf     D0,mt_loop2
	addq.b  #1,D2

mt_init3:				
	lea     mt_samplestarts(PC),A1
	asl.l   #8,D2
	asl.l   #2,D2
	addi.l  #$43C,D2	; Pattern Data start (after "M.K.")
	add.l   A0,D2
	movea.l D2,A2
	moveq.l #$1e,D0		; 30 = nbre instrument - 1
mt_loop3:
	clr.l   (A2)
	move.l  A2,(A1)+
	moveq.l #0,D1
	move.w  42(A0),D1	; sample len in word
	asl.l   #1,D1		; x2 = real len
	adda.l  D1,A2
	adda.l  #$1e,A0		; 30
	dbf     D0,mt_loop3

	ori.b   #2,$BFE001
	move.b  #6,mt_speed
	clr.w   $DFF0A8
	clr.w   $DFF0B8
	clr.w   $DFF0C8
	clr.w   $DFF0D8
	clr.b   mt_songpos
	clr.b   mt_counter
	clr.w   mt_pattpos
	rts     

mt_end:
	clr.w   $DFF0A8
	clr.w   $DFF0B8
	clr.w   $DFF0C8
	clr.w   $DFF0D8
	move.w  #$F,$DFF096
	rts    

mt_music:
	movem.l D0-D4/A0-A3/A5/A6,-(A7)
	lea     mt_data,A0
	addq.b  #1,mt_counter
	move.b  mt_counter(pc),D0
	cmp.b   mt_speed(pc),D0
	blt.s   mt_nonew
	clr.b   mt_counter
	bra	mt_getnew

mt_nonew: 
	lea     mt_voice1(pc),A6
	lea     $DFF0A0,A5
	bsr	mt_checkcom
	lea     mt_voice2(pc),A6
	lea     $DFF0B0,A5
	bsr	mt_checkcom
	lea     mt_voice3(pc),A6
	lea     $DFF0C0,A5
	bsr	mt_checkcom
	lea     mt_voice4(pc),A6
	lea     $DFF0D0,A5
	bsr	mt_checkcom
	bra	mt_exit

mt_arp: 
	moveq.l #0,D0
	move.b  mt_counter,D0
	divs    #3,D0
	swap.w  D0
	cmpi.w  #0,D0
	beq.s   mt_arp2
	cmpi.w  #2,D0
	beq.s   mt_arp1
	moveq.l #0,d0
	move.b  3(A6),D0
	lsr.b   #4,D0
	bra.s   mt_arpdo

mt_arp1: 
	moveq.l #0,D0
	move.b  3(A6),D0
	andi.b  #$0F,D0
	bra.s   mt_arpdo

mt_arp2: 
	move.w  $10(A6),D2
	bra.s   mt_arpfound

mt_arpdo: 
	asl.w   #1,D0
	moveq.l #0,D1
	move.w  $10(A6),D1
	lea     mt_periods(pc),A0
	moveq.l #$24,D7			; 36
mt_arploop: 
	move.w  (A0,D0.w),D2
	cmp.w   (A0),D1
	bge.s   mt_arpfound
	addq.l  #2,A0
	dbf     D7,mt_arploop
	rts  

mt_arpfound: 
	move.w  D2,6(A5)
	rts    

mt_getnew: 
	lea     mt_data,A0	; in mt_music
	movea.l A0,A3
	movea.l A0,A2
	adda.l  #$C,A3		; 12
	adda.l  #$400,A2	; $3B8 - pattern sequence table
	adda.l  #$43C,A0	; pattern start

	moveq.l #0,D0
	move.l  D0,D1
	move.b  mt_songpos(pc),D0
	move.b  (A2,D0.w),D1	
	asl.l   #8,D1
	asl.l   #2,D1
	add.w   mt_pattpos(pc),D1
	clr.w   mt_dmacon

	lea     $DFF0A0,A5
	lea     mt_voice1(pc),A6
	bsr.s   mt_playvoice
	lea     $DFF0B0,A5
	lea     mt_voice2(pc),A6
	bsr.s   mt_playvoice
	lea     $DFF0C0,A5
	lea     mt_voice3(pc),A6
	bsr.s   mt_playvoice
	lea     $DFF0D0,A5
	lea     mt_voice4(pc),A6
	bsr.s   mt_playvoice
	bra	mt_setdma

mt_playvoice: 
	move.l  (A0,D1.l),(A6)
	addq.l  #4,D1
	moveq.l #0,D2
	move.b  2(A6),D2
	andi.b  #$F0,D2
	lsr.b   #4,D2
	move.b  (A6),D0
	andi.b  #$F0,D0
	or.b    D0,D2
	tst.b   D2
	beq.s   mt_setregs

	moveq.l #0,D3
	lea     mt_samplestarts(pc),A1 ; -4
	move.l  D2,D4
	subq.l  #1,D2
	asl.l   #2,D2
	mulu    #$1E,D4
	move.l  (A1,D2.l),4(A6)
	move.w  (A3,D4.l),8(A6)
	move.w  2(A3,D4.l),$12(A6)
	move.w  4(A3,D4.l),D3
	tst.w   D3
	beq.s   mt_noloop
	move.l	4(A6),D2
	asl.w	#1,D3
	add.l   D3,D2
	move.l  D2,$A(A6)
	move.w  4(A3,D4.l),D0
	add.w   6(A3,D4.l),D0
	move.w  D0,8(A6)
	move.w  6(A3,D4.l),$E(A6)	; $a
	move.w  $12(A6),8(A5)
	bra.s   mt_setregs		; mt_hejaSverige

mt_noloop: 
	move.l  4(A6),D2
	add.l   D3,D2
	move.l  D2,$A(A6)
mt_hejaSverige:
	move.w  6(A3,D4.l),$E(A6)
	move.w  $12(A6),8(A5)		; like ST2 - NT: $13

mt_setregs: 
	move.w  (A6),D0
	andi.w  #$FFF,D0
	beq	mt_checkcom2
	move.b  2(A6),D0
	andi.b  #$F,D0
	cmpi.b  #3,D0
	bne.s   mt_setperiod
	bsr	mt_setport
	bra	mt_checkcom2

mt_setperiod: 
	move.w  (A6),$10(A6)	
	andi.w  #$FFF,$10(A6)
	move.w  $14(A6),D0	
	move.w  D0,$DFF096
	clr.b   $1B(A6)		

	move.l  4(A6),(A5)
	move.w  8(A6),4(A5)
	move.w  $10(A6),D0
	andi.w  #$FFF,D0
	move.w  D0,6(A5)

	move.w  $14(A6),D0	
	or.w    D0,mt_dmacon	;dmaset
	bra	mt_checkcom2

mt_setdma:
	move.w  #$12C,D0
mt_wait1: dbf     D0,mt_wait1
	move.w  mt_dmacon,D0
	ori.w   #$8000,D0
	move.w  D0,$DFF096
	move.w  #$12C,D0	; 300
mt_wait2: dbf     D0,mt_wait2	
	lea     $DFF000,A5		; mt_setdma
	lea     mt_voice4(pc),A6
	move.l  $A(A6),$D0(A5)
	move.w  $E(A6),$D4(A5)
	lea     mt_voice3(pc),A6
	move.l  $A(A6),$C0(A5)
	move.w  $E(A6),$C4(A5)
	lea     mt_voice2(pc),A6
	move.l  $A(A6),$B0(A5)
	move.w  $E(A6),$B4(A5)
	lea     mt_voice1(pc),A6
	move.l  $A(A6),$A0(A5)
	move.w  $E(A6),$A4(A5)

	addi.w  #$10,mt_pattpos
	cmpi.w  #$400,mt_pattpos	; pattern pos
	bne.s   mt_exit
mt_next: clr.w   mt_pattpos
	clr.b   mt_break
	addq.b  #1,mt_songpos
	andi.b  #$7F,mt_songpos
	move.b  mt_songpos(pc),D1
	cmp.b   mt_data+$3FE,D1		; mt_data + songlen
	bne.s   mt_exit
	move.b  mt_data+$3FF,mt_songpos
	bsr	SongEnd
mt_exit: tst.b   mt_break
	bne.s   mt_next
	movem.l (A7)+,D0-D4/A0-A3/A5/A6
	rts     

mt_setport: 
	move.w  (A6),D2
	andi.w  #$FFF,D2
	move.w  D2,$18(A6)	; $16
	move.w  $10(A6),D0
	clr.b   $16(A6)		; $14
	cmp.w   D0,D2
	beq.s   mt_clrport
	bge.s   mt_rts
	move.b  #1,$16(A6)
	rts     
mt_clrport: clr.w   $18(A6)
mt_rts: rts     

mt_port: 
	move.b  3(A6),D0
	beq.s   mt_myslide
	move.b  D0,$17(A6)	; $15
	clr.b   3(A6)
mt_myslide: 
	tst.w   $18(A6)	; $16
	beq.s   mt_rts
	moveq.l #0,D0
	move.b  $17(A6),D0	; $15
	tst.b   $16(A6)		; $14
	bne.s   mt_sub
	add.w   D0,$10(A6)
	move.w  $18(A6),D0	; $16
	cmp.w   $10(A6),D0
	bgt.s   mt_portok2
	move.w  $18(A6),$10(A6)
	clr.w   $18(A6)
mt_portok2: move.w  $10(A6),6(A5)
	rts     

mt_sub: sub.w   D0,$10(A6)
	move.w  $18(A6),D0	; $16
	cmp.w   $10(A6),D0	; $10
	blt.s   mt_portok2
	move.w  $18(A6),$10(A6)	; $16
	clr.w   $18(A6)		; $16
	move.w  $10(A6),6(A5)
	rts     

mt_vib: move.b  3(A6),D0
	beq.s   mt_vib2
	move.b  D0,$1A(A6)	; $18
mt_vib2: move.b  $1B(A6),D0	; $19
	lea     mt_sin(pc),A4
	lsr.w   #2,D0
	andi.w  #$1F,D0
	moveq.l #0,D2
	move.b  (A4,D0.w),D2
	move.b  $1A(A6),D0	; $18
	andi.w  #$F,D0
	mulu    D0,D2
	lsr.w   #6,D2
	move.w  $10(A6),D0
	tst.b   $1B(A6)		; $19
	bmi.s   mt_vibsub
	add.w   D2,D0
	bra.s   mt_vib3
mt_vibsub: 
	sub.w   D2,D0
mt_vib3: move.w  D0,6(A5)
	move.b  $1A(A6),D0	; $18
	lsr.w   #2,D0
	andi.w  #$3C,D0
	add.b   D0,$1B(A6)	; $19
	rts     

mt_portok:
mt_normper:
	move.w  $10(A6),6(A5)
	rts     

mt_checkcom: 
	move.w  2(A6),D0
	andi.w  #$FFF,D0
	beq.s   mt_normper
	move.b  2(A6),D0
	andi.b  #$F,D0
	tst.b   D0
	beq	mt_arp
	cmpi.b  #1,D0
	beq.s   mt_portup
	cmpi.b  #2,D0
	beq	mt_portdown
	cmpi.b  #3,D0
	beq	mt_port
	cmpi.b  #4,D0
	beq	mt_vib
	move.w  $10(A6),6(A5)
	cmpi.b  #$0A,D0
	beq.s   mt_volslide
	rts     

mt_volslide: 
	moveq.l #0,D0
	move.b  3(A6),D0
	lsr.b   #4,D0
	tst.b   D0
	beq.s   mt_voldown
	add.w   D0,$12(A6)	; $10
	cmpi.w  #$40,$12(A6)	; $10
	bmi.s   mt_vol2
	move.w  #$40,$12(A6)
mt_vol2:
	move.w  $12(A6),8(A5)	; $10,6
	rts     

mt_voldown: 
	moveq.l #0,D0
	move.b  3(A6),D0
	andi.b  #$F,D0
	sub.w   D0,$12(A6)	; $10
	bpl.s   mt_vol4
	clr.w   $12(A6)
mt_vol4: 
	move.w  $12(A6),8(A5)
	rts     

mt_portup: 
	moveq.l #0,D0
	move.b  3(A6),D0
	sub.w   D0,$10(A6)
	move.w  $10(A6),D0
	andi.w  #$0FFF,D0
	cmpi.w  #$71,D0
	bpl.s   mt_portup2
	andi.w  #$F000,$10(A6)
	ori.w   #$71,$10(A6)
mt_portup2: 
	move.w  $10(A6),D0
	andi.w  #$0FFF,D0
	move.w  D0,6(A5)
	rts     

mt_portdown: 
	clr.w   D0
	move.b  3(A6),D0
	add.w   D0,$10(A6)
	move.w  $10(A6),D0
	andi.w  #$FFF,D0
	cmpi.w  #$358,D0
	bmi.s   mt_portdown2
	andi.w  #$F000,$10(A6)
	ori.w   #$358,$10(A6)
mt_portdown2: 
	move.w  $10(A6),D0
	andi.w  #$0FFF,D0
	move.w  D0,6(A5)
	rts     

mt_checkcom2: 
	move.b  2(A6),D0
	andi.b  #$F,D0
	cmpi.b  #$E,D0
	beq.s   mt_filter
	cmpi.b  #$D,D0
	beq.s   mt_pattbreak
	cmpi.b  #$B,D0
	beq.s   mt_songjmp
	cmpi.b  #$C,D0
	beq.s   mt_setvol1
	cmpi.b  #$F,D0
	beq.s   mt_setspeed
	rts     

mt_filter: 
	move.b  3(A6),D0
	andi.b  #1,D0
	asl.b   #1,D0
	andi.b  #$FD,$BFE001
	or.b    D0,$BFE001
	rts     

mt_pattbreak: 
	not.b   mt_break	; move.b #1,mt_break
	rts     

mt_songjmp:	
	move.b  3(A6),D0
	subq.b  #1,D0
	move.b  D0,mt_songpos
	not.b   mt_break
	rts     

mt_setvol1:	
	cmpi.b  #$40,3(A6)
	ble.s   mt_sv2
	move.b  #$40,3(A6)
mt_sv2: move.b  3(A6),8(A5)
	rts     

mt_setspeed: 
	cmpi.b  #$1F,3(A6)
	ble.s   mt_sp2
	move.b  #$1F,3(A6)
mt_sp2:	move.b  3(A6),D0
	beq.s   mt_sp3
	move.b  D0,mt_speed
	clr.b   mt_counter
mt_sp3:	rts     

mt_sin:	
	dc.w	$0018,$314a,$6178,$8da1,$b4c5,$d4e0
	dc.w	$ebf4,$fafd,$fffd,$faf4,$ebe0,$d4c5
	dc.w	$b4a1,$8d78,$614a,$3118
mt_periods:	; mt_arpeggio
	dc.w	$0358,$0328,$02fa,$02d0,$02a6,$0280
	dc.w	$025c,$023a,$021a,$01fc,$01e0,$01c5
	dc.w	$01ac,$0194,$017d,$0168,$0153,$0140
	dc.w	$012e,$011d,$010d,$00fe,$00f0,$00e2
	dc.w	$00d6,$00ca,$00be,$00b4,$00aa,$00a0
	dc.w	$0097,$008f,$0087,$007f,$0078,$0071
	dc.w	$0000,$0000
mt_speed:	dc.b	6
mt_songpos:	dc.b	0	; 1
mt_pattpos:	dc.w	0	; $f0
mt_counter:	dc.b	0	; 5
mt_break:	dc.b	0
mt_dmacon:	dc.w	0	; 1
mt_samplestarts: 	;dcb.l	$1F,0
	dc.w	$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
mt_voice1:	;dcb.w 10,0
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	1
	dc.w	$0000,$0000,$0000	
mt_voice2:	;dcb.w 10,0
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	2
	dc.w	$0000,$0000,$0000
mt_voice3:	;dcb.w 10,0
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	4
	dc.w	$0000,$0000,$0000
mt_voice4:	;dcb.w 10,0
	dc.w	$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	dc.w	8
	dc.w	$0000,$0000,$0000
	
;
;
	SECTION Module,Data_c
;
;

mt_data
	incbin	"mod.windsurf"			; include a NoiseTracker module here !

	dc.l	"KILL"				; old NT-routine bug!! (not existent in
						; the internal NT replay routine)

